#include "QueryTab.h"
#include "Highlighter.h"
#include "TextEdit.h"
#include "MainTextEdit.h"

/* 
	  
*/
QueryTab::QueryTab(QWidget * parent) : QTabWidget(parent)
{
	MainTextEdit* mainTextEdit = new MainTextEdit();
	new Highlighter(mainTextEdit->GetTextEdit()->document());

	this->addTab(mainTextEdit, QIcon("images/query.png"), tr("Query"));

	QPushButton* button = new QPushButton(QIcon("images/tabClose.png"), "");
	this->setCornerWidget(button);

	//((QTextEdit*)(this->widget(0)))->createStandardContextMenu()->addMenu(tr("dddd"));
	//((QTextEdit*)(this->widget(0)))->createStandardContextMenu()->addMenu(tr("aaaaa"));

	connect(this->cornerWidget(), SIGNAL(clicked()), this, SLOT(CornerWidgetClicked()));
}


/* 
	ڳ  Ŭ 
*/
void QueryTab::CornerWidgetClicked()
{
	if (this->currentIndex() != 0) {

		/*
		int messageRet = QMessageBox::warning(this, "Overwrite", 
		tr(" ڽϱ?"), QMessageBox::Ok | QMessageBox::Cancel);
		*/
		
		int messageRet = QMessageBox::warning(this, "Delete Tab", tr("ðڽϱ?"), QMessageBox::Ok | QMessageBox::Cancel);
		
		if( messageRet == QMessageBox::Ok){
			this->removeTab(this->currentIndex());
		}
	}
	
	else{
		QMessageBox::warning(this, "Can't Delete", tr("    ϴ."), QMessageBox::Ok);
	}
}


/* 
	   
*/
void QueryTab::Save()
{
//	if( this->currentIndex() != 0){
		
		/*	if( ((QTextEdit*)(this->currentWidget()))->document()->isModified() == true ){
		qDebug() << "isModified";
		}
		
		else{
		qDebug() << "isNotModified";
		}
		*/
		
		QString fileName = QFileDialog::getSaveFileName(this, tr("Save File"), "untitled", 
									tr("SQL (*.sql)"));

		QFile file(fileName+ ".sql");

		if (!file.open(QFile::WriteOnly | QFile::Text)) {
			QMessageBox::warning(this, tr("Application"),
				tr("Cannot write file %1:\n%2.")
				.arg(fileName)
				.arg(file.errorString()));
		}
		
		else{
			QTextStream out(&file);
			QApplication::setOverrideCursor(Qt::WaitCursor);
			out << ((QTextEdit*)(this->currentWidget()))->toPlainText();
			QApplication::restoreOverrideCursor();
		}
//	}
}


/* 
	 ǿ  
*/
void QueryTab::Open()
{
	QString fileName = QFileDialog::getOpenFileName(this, tr("Open File"), "", tr("Images (*.sql)"));

	QFile file(fileName);

    if (!file.open(QFile::ReadOnly | QFile::Text)) {
        QMessageBox::warning(this, tr("Application"),
			tr("Cannot read file %1:\n%2.")
			.arg(fileName)
			.arg(file.errorString()));
    }
	
	else{
		QStringList list = fileName.split("/", QString::SkipEmptyParts);

		QString buffer = list[list.count()-1];
		buffer.remove(buffer.count()-4, 4);

		QTextEdit* textEdit = new QTextEdit();
		new Highlighter(textEdit->document());

		this->addTab(textEdit, QIcon("images/test.png"), buffer);
		this->setCurrentIndex(this->count()-1);
		
		QTextStream in(&file);
		QApplication::setOverrideCursor(Qt::WaitCursor);
		((QTextEdit*)(this->currentWidget()))->setPlainText(in.readAll());
		QApplication::restoreOverrideCursor();
	}
}


void QueryTab::contextMenuEvent( QContextMenuEvent * event )
{
	qDebug() << "Test";
}

void QueryTab::Slot_SetBreakPointTab()
{
	((MainTextEdit*)(this->currentWidget()))->slot_setBreakpoint();
}

void QueryTab::Slot_AllBreakpointCleanTab()
{
	((MainTextEdit*)(this->currentWidget()))->slot_Allbreakpointclear();
}
